package jadean.dean.java;

import jadean.dean.Resource;
import jadean.dean.java.resources.JavaResourceContext;

public abstract class JavaResource extends Resource implements Comparable<JavaResource> {
	private String _name;
	private JavaResourceContext _context;
	
	public JavaResource(String name, JavaResourceContext context) {
		this.setName(name);
		this.setContext(context);
	}

	public String getName() {
		return this._name;
	}
	
	public void setName(String name) {
		this._name = name;
	}
	
	public JavaResourceContext getContext() {
		return this._context;
	}
	
	public void setContext(JavaResourceContext context) {
		this._context = context;
	}
	
	public String toString() {
		return this.getName();
	}

	public int compareTo(JavaResource r)  {
		if (this.equals(r)) return 0;
		else return this.getName().compareTo(r.getName());
	}
	
	@Override
	public int hashCode() {
		if (this.getName().lastIndexOf(".") != -1) {
			return this.getName().substring(this.getName().lastIndexOf(".") + 1).hashCode();
		}
		return this.getName().hashCode();
	}
	
	@Override
	public boolean equals(Object o) {
		if (o instanceof JavaResource) {
			JavaResource r = (JavaResource) o;
			return r.getName().equals(this.getName());
		}
		return false;
	}
	
}
